﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Globalization;
using System.Web;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class BprDoDDeploymentImporter : AHOBPRBaseBO, IDeploymentImporter
    {
        public BprDoDDeploymentImports GetDoDDeploymentImports(string edipi, string ssn)
        {
            if (string.IsNullOrEmpty(edipi))
            {
                return null;
            }
            else
            {
                List<DOD_DEPLOYMENT_IMPORT> import = new List<DOD_DEPLOYMENT_IMPORT>();
                AHOBPRRegistrantManager registrantManager = new AHOBPRRegistrantManager();
                REGISTRANT registrant = registrantManager.GetRegistrantById(edipi, ssn);
                List<DOD_DEPLOYMENT_IMPORT> deployments = new List<DOD_DEPLOYMENT_IMPORT>();
                using (_dbAhobpr = GetDataContext())
                {
                    try
                    {
                        SetLoadWithForDoDImports(_dbAhobpr);
                        deployments = (from e in _dbAhobpr.DOD_DEPLOYMENT_IMPORTs
                                       where (e.EDIPI == edipi)
                                       orderby e.DEPLOYMENT_START_DATE
                                       select e).ToList();
                    }
                    catch
                    {
                        new AHOBPRShared().LogErrorMessage("No Deployments For User", GetType().Name, "User: " + edipi + " has no deployments in DB");
                        deployments = new List<DOD_DEPLOYMENT_IMPORT>();
                    }
                }

                BprDoDDeploymentImports bprDoDDeploymentImports = new BprDoDDeploymentImports();
                if (deployments.Count > 0)
                {
                    bprDoDDeploymentImports.edipi = edipi;
                    bprDoDDeploymentImports.ssn = ssn;

                    if (registrant != null)
                    {
                        bprDoDDeploymentImports._id = registrant.REGISTRANT_ID.ToString();
                        bprDoDDeploymentImports.dob = registrant.BIRTH_DATE.HasValue ? Convert.ToDateTime(registrant.BIRTH_DATE).ToUniversalTime().ToString("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'fff'Z'", CultureInfo.CurrentCulture) : string.Empty;
                        bprDoDDeploymentImports.firstName = registrant.FIRST_NAME;
                        bprDoDDeploymentImports.importId = registrant.REGISTRANT_ID.ToString();
                        bprDoDDeploymentImports.lastName = registrant.LAST_NAME;
                        bprDoDDeploymentImports.middleName = registrant.MIDDLE_NAME;

                    }
                    List<BprDoDDeployment> bprDeployments = new List<BprDoDDeployment>();
                    foreach (DOD_DEPLOYMENT_IMPORT deployment in deployments)
                    {
                        BprDoDDeployment bprDeployment = new BprDoDDeployment();
                        bprDeployment.branchOfService = deployment.SERVICE;
                        bprDeployment.deploymentCountryCode = deployment.LOCATION;
                        bprDeployment.deploymentStartDate = deployment.LOCATION_START_DATE.ToShortDateString();
                        bprDeployment.deploymentEndDate = deployment.LOCATION_END_DATE.ToShortDateString();
                        bprDeployment.dutyProjectCode = string.Empty;

                        bprDeployments.Add(bprDeployment);
                    }
                    bprDoDDeploymentImports.deployments = bprDeployments.ToArray();
                }
                else
                {
                    bprDoDDeploymentImports = null;
                }

                return bprDoDDeploymentImports;
            }
        }
        private void SetLoadWithForDoDImports(AHOBPRDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<DOD_DEPLOYMENT_IMPORT>(e => e.LOCATION);
            lo.LoadWith<DOD_DEPLOYMENT_IMPORT>(e => e.PAY_PLAN_GRADE);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;
        }
    }
}
